/* - LEDDetachListener -
 * We'll clear all our fields and disable all the editable fields to 
 * prevent errors
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.LEDPhidget;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;

public class LEDDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numLEDTxt;
    private JComboBox ledCmb;
    private JSlider ledBrightScrl;
    
    /** Creates a new instance of LEDDetachListener */
    public LEDDetachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numLEDTxt, 
            JComboBox ledCmb, JSlider ledBrightScrl)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numLEDTxt = numLEDTxt;
        this.ledCmb = ledCmb;
        this.ledBrightScrl = ledBrightScrl;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            LEDPhidget detached = (LEDPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numLEDTxt.setText("");
            
            ledCmb.setEnabled(false);
            ledCmb.removeAllItems();
            ledBrightScrl.setEnabled(false);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
